/* ex: set ro ft=c: -*- buffer-read-only: t -*-
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is auto-generated by Unicode::Towctrans 0.03
 * gen_wctrans
 * for Unicode 16.0.0
 * Any changes here will be lost!
 */
/*
Copyright (c) 2005-2014 Rich Felker, et al.
Copyright (c) 2018,2020,2026 Reini Urban

--------------------------------------------------------------
This code is licensed under the following standard MIT license
--------------------------------------------------------------

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------
*/

#include <assert.h>
#include <stdint.h>
#include <wctype.h>
#ifdef HAVE_LOCALE_TR
#include <locale.h>
#include <string.h>
#endif

/* map from upper until upper, to lower */
#define CASEMAP(u1, u2, l) {(u1), (l) - (u1), (u2) - (u1) + 1}
/* map from upper until lower, with dist 1 */
#define CASELACE(u1, u2) CASEMAP((u1), (u2), (u1) + 1)

/* for Unicode 16.0.0 */
#define TOWCTRANS_UNICODE_VERSION 16

static const struct casemaps_s {
    uint16_t upper; /* base */
    int8_t lower;   /* distance from upper to lower. 1 with LACE */
    uint8_t len;    /* how many */
} casemaps[69] = {
    /* upper: 0x41 - 0xff21 */
    /* from, until, to */
    CASEMAP(0x0041, 0x005a, 0x0061), /* 'A'->'Z'..'a' {, 32, 26} */
    CASEMAP(0x00c0, 0x00d6, 0x00e0), /* 'À'->'Ö'..'à' {, 32, 23} */
    CASEMAP(0x00d8, 0x00de, 0x00f8), /* 'Ø'->'Þ'..'ø' {, 32, 7} */
    CASELACE(0x0100, 0x012e),        /* 'Ā'->'Į' {, 1, 47} */
    CASELACE(0x0132, 0x0136),        /* 'Ĳ'->'Ķ' {, 1, 5} */
    CASELACE(0x0139, 0x0147),        /* 'Ĺ'->'Ň' {, 1, 15} */
    CASELACE(0x014a, 0x0176),        /* 'Ŋ'->'Ŷ' {, 1, 45} */
    CASELACE(0x0179, 0x017d),        /* 'Ź'->'Ž' {, 1, 5} */
    CASELACE(0x0182, 0x0184),        /* 'Ƃ'->'Ƅ' {, 1, 3} */
    CASELACE(0x01a0, 0x01a4),        /* 'Ơ'->'Ƥ' {, 1, 5} */
    CASELACE(0x01b3, 0x01b5),        /* 'Ƴ'->'Ƶ' {, 1, 3} */
    CASELACE(0x01cb, 0x01db),        /* 'ǋ'->'Ǜ' {, 1, 17} */
    CASELACE(0x01de, 0x01ee),        /* 'Ǟ'->'Ǯ' {, 1, 17} */
    CASELACE(0x01f2, 0x01f4),        /* 'ǲ'->'Ǵ' {, 1, 3} */
    CASELACE(0x01f8, 0x021e),        /* 'Ǹ'->'Ȟ' {, 1, 39} */
    CASELACE(0x0222, 0x0232),        /* 'Ȣ'->'Ȳ' {, 1, 17} */
    CASELACE(0x0246, 0x024e),        /* 'Ɇ'->'Ɏ' {, 1, 9} */
    CASELACE(0x0370, 0x0372),        /* 'Ͱ'->'Ͳ' {, 1, 3} */
    CASEMAP(0x0388, 0x038a, 0x03ad), /* 'Έ'->'Ί'..'έ' {, 37, 3} */
    CASEMAP(0x038e, 0x038f, 0x03cd), /* 'Ύ'->'Ώ'..'ύ' {, 63, 2} */
    CASEMAP(0x0391, 0x03a1, 0x03b1), /* 'Α'->'Ρ'..'α' {, 32, 17} */
    CASEMAP(0x03a3, 0x03ab, 0x03c3), /* 'Σ'->'Ϋ'..'σ' {, 32, 9} */
    CASELACE(0x03d8, 0x03ee),        /* 'Ϙ'->'Ϯ' {, 1, 23} */
    CASEMAP(0x0400, 0x040f, 0x0450), /* 'Ѐ'->'Џ'..'ѐ' {, 80, 16} */
    CASEMAP(0x0410, 0x042f, 0x0430), /* 'А'->'Я'..'а' {, 32, 32} */
    CASELACE(0x0460, 0x0480),        /* 'Ѡ'->'Ҁ' {, 1, 33} */
    CASELACE(0x048a, 0x04be),        /* 'Ҋ'->'Ҿ' {, 1, 53} */
    CASELACE(0x04c1, 0x04cd),        /* 'Ӂ'->'Ӎ' {, 1, 13} */
    CASELACE(0x04d0, 0x052e),        /* 'Ӑ'->'Ԯ' {, 1, 95} */
    CASEMAP(0x0531, 0x0556, 0x0561), /* 'Ա'->'Ֆ'..'ա' {, 48, 38} */
    CASEMAP(0x13f0, 0x13f5, 0x13f8), /* 'Ᏸ'->'Ᏽ'..'ᏸ' {, 8, 6} */
    CASELACE(0x1e00, 0x1e94),        /* 'Ḁ'->'Ẕ' {, 1, 149} */
    CASELACE(0x1ea0, 0x1efe),        /* 'Ạ'->'Ỿ' {, 1, 95} */
    CASEMAP(0x1f08, 0x1f0f, 0x1f00), /* 'Ἀ'->'Ἇ'..'ἀ' {, -8, 8} */
    CASEMAP(0x1f18, 0x1f1d, 0x1f10), /* 'Ἐ'->'Ἕ'..'ἐ' {, -8, 6} */
    CASEMAP(0x1f28, 0x1f2f, 0x1f20), /* 'Ἠ'->'Ἧ'..'ἠ' {, -8, 8} */
    CASEMAP(0x1f38, 0x1f3f, 0x1f30), /* 'Ἰ'->'Ἷ'..'ἰ' {, -8, 8} */
    CASEMAP(0x1f48, 0x1f4d, 0x1f40), /* 'Ὀ'->'Ὅ'..'ὀ' {, -8, 6} */
    CASEMAP(0x1f68, 0x1f6f, 0x1f60), /* 'Ὠ'->'Ὧ'..'ὠ' {, -8, 8} */
    CASEMAP(0x1f88, 0x1f8f, 0x1f80), /* 'ᾈ'->'ᾏ'..'ᾀ' {, -8, 8} */
    CASEMAP(0x1f98, 0x1f9f, 0x1f90), /* 'ᾘ'->'ᾟ'..'ᾐ' {, -8, 8} */
    CASEMAP(0x1fa8, 0x1faf, 0x1fa0), /* 'ᾨ'->'ᾯ'..'ᾠ' {, -8, 8} */
    CASEMAP(0x1fb8, 0x1fb9, 0x1fb0), /* 'Ᾰ'->'Ᾱ'..'ᾰ' {, -8, 2} */
    CASEMAP(0x1fba, 0x1fbb, 0x1f70), /* 'Ὰ'->'Ά'..'ὰ' {, -74, 2} */
    CASEMAP(0x1fc8, 0x1fcb, 0x1f72), /* 'Ὲ'->'Ή'..'ὲ' {, -86, 4} */
    CASEMAP(0x1fd8, 0x1fd9, 0x1fd0), /* 'Ῐ'->'Ῑ'..'ῐ' {, -8, 2} */
    CASEMAP(0x1fda, 0x1fdb, 0x1f76), /* 'Ὶ'->'Ί'..'ὶ' {, -100, 2} */
    CASEMAP(0x1fe8, 0x1fe9, 0x1fe0), /* 'Ῠ'->'Ῡ'..'ῠ' {, -8, 2} */
    CASEMAP(0x1fea, 0x1feb, 0x1f7a), /* 'Ὺ'->'Ύ'..'ὺ' {, -112, 2} */
    CASEMAP(0x1ffa, 0x1ffb, 0x1f7c), /* 'Ὼ'->'Ώ'..'ὼ' {, -126, 2} */
    CASEMAP(0x2160, 0x216f, 0x2170), /* 'Ⅰ'->'Ⅿ'..'ⅰ' {, 16, 16} */
    CASEMAP(0x24b6, 0x24cf, 0x24d0), /* 'Ⓐ'->'Ⓩ'..'ⓐ' {, 26, 26} */
    CASEMAP(0x2c00, 0x2c2f, 0x2c30), /* 'Ⰰ'->'Ⱟ'..'ⰰ' {, 48, 48} */
    CASELACE(0x2c67, 0x2c6b),        /* 'Ⱨ'->'Ⱬ' {, 1, 5} */
    CASELACE(0x2c80, 0x2ce2),        /* 'Ⲁ'->'Ⳣ' {, 1, 99} */
    CASELACE(0x2ceb, 0x2ced),        /* 'Ⳬ'->'Ⳮ' {, 1, 3} */
    CASELACE(0xa640, 0xa66c),        /* 'Ꙁ'->'Ꙭ' {, 1, 45} */
    CASELACE(0xa680, 0xa69a),        /* 'Ꚁ'->'Ꚛ' {, 1, 27} */
    CASELACE(0xa722, 0xa72e),        /* 'Ꜣ'->'Ꜯ' {, 1, 13} */
    CASELACE(0xa732, 0xa76e),        /* 'Ꜳ'->'Ꝯ' {, 1, 61} */
    CASELACE(0xa779, 0xa77b),        /* 'Ꝺ'->'Ꝼ' {, 1, 3} */
    CASELACE(0xa77e, 0xa786),        /* 'Ꝿ'->'Ꞇ' {, 1, 9} */
    CASELACE(0xa790, 0xa792),        /* 'Ꞑ'->'Ꞓ' {, 1, 3} */
    CASELACE(0xa796, 0xa7a8),        /* 'Ꞗ'->'Ꞩ' {, 1, 19} */
    CASELACE(0xa7b4, 0xa7c2),        /* 'Ꞵ'->'Ꟃ' {, 1, 15} */
    CASELACE(0xa7c7, 0xa7c9),        /* 'Ꟈ'->'Ꟊ' {, 1, 3} */
    CASELACE(0xa7d6, 0xa7da),        /* 'Ꟗ'->'Ꟛ' {, 1, 5} */
    CASELACE(0xa7f5, 0xa7f5),        /* 'Ꟶ'->'Ꟶ' {, 1, 1} */
    CASEMAP(0xff21, 0xff3a, 0xff41), /* 'Ａ'->'Ｚ'..'ａ' {, 32, 26} */
};
static const struct casemapsl_s {
    uint32_t upper; /* base */
    int lower;      /* distance from upper to lower. 1 with LACE */
    uint16_t len;   /* how many */
} casemapsl[20] = {
    /* upper: 0x189 - 0x1e900 */
    /* from, until, to */
    CASEMAP(0x00189, 0x0018a, 0x00256), /* 'Ɖ'->'Ɗ'..'ɖ' {, 205, 2} */
    CASEMAP(0x001b1, 0x001b2, 0x0028a), /* 'Ʊ'->'Ʋ'..'ʊ' {, 217, 2} */
    CASEMAP(0x003fd, 0x003ff, 0x0037b), /* 'Ͻ'->'Ͽ'..'ͻ' {, -130, 3} */
    CASEMAP(0x010a0, 0x010c5, 0x02d00), /* 'Ⴀ'->'Ⴥ'..'ⴀ' {, 7264, 38} */
    CASEMAP(0x013a0, 0x013ef, 0x0ab70), /* 'Ꭰ'->'Ꮿ'..'ꭰ' {, 38864, 80} */
    CASEMAP(0x01c90, 0x01cba, 0x010d0), /* 'Ა'->'Ჺ'..'ა' {, -3008, 43} */
    CASEMAP(0x01cbd, 0x01cbf, 0x010fd), /* 'Ჽ'->'Ჿ'..'ჽ' {, -3008, 3} */
    CASEMAP(0x01ff8, 0x01ff9, 0x01f78), /* 'Ὸ'->'Ό'..'ὸ' {, -128, 2} */
    CASEMAP(0x02c7e, 0x02c7f, 0x0023f), /* 'Ȿ'->'Ɀ'..'ȿ' {, -10815, 2} */
    CASEMAP(0x10400, 0x10427, 0x10428), /* '𐐀'->'𐐧'..'𐐨' {, 40, 40} */
    CASEMAP(0x104b0, 0x104d3, 0x104d8), /* '𐒰'->'𐓓'..'𐓘' {, 40, 36} */
    CASEMAP(0x10570, 0x1057a, 0x10597), /* '𐕰'->'𐕺'..'𐖗' {, 39, 11} */
    CASEMAP(0x1057c, 0x1058a, 0x105a3), /* '𐕼'->'𐖊'..'𐖣' {, 39, 15} */
    CASEMAP(0x1058c, 0x10592, 0x105b3), /* '𐖌'->'𐖒'..'𐖳' {, 39, 7} */
    CASEMAP(0x10594, 0x10595, 0x105bb), /* '𐖔'->'𐖕'..'𐖻' {, 39, 2} */
    CASEMAP(0x10c80, 0x10cb2, 0x10cc0), /* '𐲀'->'𐲲'..'𐳀' {, 64, 51} */
    CASEMAP(0x10d50, 0x10d65, 0x10d70), /* '𐵐'->'𐵥'..'𐵰' {, 32, 22} */
    CASEMAP(0x118a0, 0x118bf, 0x118c0), /* '𑢠'->'𑢿'..'𑣀' {, 32, 32} */
    CASEMAP(0x16e40, 0x16e5f, 0x16e60), /* '𖹀'->'𖹟'..'𖹠' {, 32, 32} */
    CASEMAP(0x1e900, 0x1e921, 0x1e922), /* '𞤀'->'𞤡'..'𞤢' {, 34, 34} */
};

static const unsigned short pairs[128][2] = {
    /* upper: 0x49 - 0xa7dc */
    /* upper, lower */
    {0x0049, 0x0131}, /* 'I' -> 'ı' */
    {0x0053, 0x017f}, /* 'S' -> 'ſ' */
    {0x0130, 0x0069}, /* 'İ' -> 'i' */
    {0x0178, 0x00ff}, /* 'Ÿ' -> 'ÿ' */
    {0x0181, 0x0253}, /* 'Ɓ' -> 'ɓ' */
    {0x0186, 0x0254}, /* 'Ɔ' -> 'ɔ' */
    {0x0187, 0x0188}, /* 'Ƈ' -> 'ƈ' */
    {0x018b, 0x018c}, /* 'Ƌ' -> 'ƌ' */
    {0x018e, 0x01dd}, /* 'Ǝ' -> 'ǝ' */
    {0x018f, 0x0259}, /* 'Ə' -> 'ə' */
    {0x0190, 0x025b}, /* 'Ɛ' -> 'ɛ' */
    {0x0191, 0x0192}, /* 'Ƒ' -> 'ƒ' */
    {0x0193, 0x0260}, /* 'Ɠ' -> 'ɠ' */
    {0x0194, 0x0263}, /* 'Ɣ' -> 'ɣ' */
    {0x0196, 0x0269}, /* 'Ɩ' -> 'ɩ' */
    {0x0197, 0x0268}, /* 'Ɨ' -> 'ɨ' */
    {0x0198, 0x0199}, /* 'Ƙ' -> 'ƙ' */
    {0x019c, 0x026f}, /* 'Ɯ' -> 'ɯ' */
    {0x019d, 0x0272}, /* 'Ɲ' -> 'ɲ' */
    {0x019f, 0x0275}, /* 'Ɵ' -> 'ɵ' */
    {0x01a6, 0x0280}, /* 'Ʀ' -> 'ʀ' */
    {0x01a7, 0x01a8}, /* 'Ƨ' -> 'ƨ' */
    {0x01a9, 0x0283}, /* 'Ʃ' -> 'ʃ' */
    {0x01ac, 0x01ad}, /* 'Ƭ' -> 'ƭ' */
    {0x01ae, 0x0288}, /* 'Ʈ' -> 'ʈ' */
    {0x01af, 0x01b0}, /* 'Ư' -> 'ư' */
    {0x01b7, 0x0292}, /* 'Ʒ' -> 'ʒ' */
    {0x01b8, 0x01b9}, /* 'Ƹ' -> 'ƹ' */
    {0x01bc, 0x01bd}, /* 'Ƽ' -> 'ƽ' */
    {0x01c4, 0x01c6}, /* 'Ǆ' -> 'ǆ' */
    {0x01c4, 0x01c5}, /* 'Ǆ' -> 'ǅ' */
    {0x01c5, 0x01c6}, /* 'ǅ' -> 'ǆ' */
    {0x01c7, 0x01c9}, /* 'Ǉ' -> 'ǉ' */
    {0x01c7, 0x01c8}, /* 'Ǉ' -> 'ǈ' */
    {0x01c8, 0x01c9}, /* 'ǈ' -> 'ǉ' */
    {0x01ca, 0x01cc}, /* 'Ǌ' -> 'ǌ' */
    {0x01ca, 0x01cb}, /* 'Ǌ' -> 'ǋ' */
    {0x01f1, 0x01f3}, /* 'Ǳ' -> 'ǳ' */
    {0x01f1, 0x01f2}, /* 'Ǳ' -> 'ǲ' */
    {0x01f6, 0x0195}, /* 'Ƕ' -> 'ƕ' */
    {0x01f7, 0x01bf}, /* 'Ƿ' -> 'ƿ' */
    {0x0220, 0x019e}, /* 'Ƞ' -> 'ƞ' */
    {0x023a, 0x2c65}, /* 'Ⱥ' -> 'ⱥ' */
    {0x023b, 0x023c}, /* 'Ȼ' -> 'ȼ' */
    {0x023d, 0x019a}, /* 'Ƚ' -> 'ƚ' */
    {0x023e, 0x2c66}, /* 'Ⱦ' -> 'ⱦ' */
    {0x0241, 0x0242}, /* 'Ɂ' -> 'ɂ' */
    {0x0243, 0x0180}, /* 'Ƀ' -> 'ƀ' */
    {0x0244, 0x0289}, /* 'Ʉ' -> 'ʉ' */
    {0x0245, 0x028c}, /* 'Ʌ' -> 'ʌ' */
    {0x0376, 0x0377}, /* 'Ͷ' -> 'ͷ' */
    {0x037f, 0x03f3}, /* 'Ϳ' -> 'ϳ' */
    {0x0386, 0x03ac}, /* 'Ά' -> 'ά' */
    {0x038c, 0x03cc}, /* 'Ό' -> 'ό' */
    {0x0392, 0x03d0}, /* 'Β' -> 'ϐ' */
    {0x0395, 0x03f5}, /* 'Ε' -> 'ϵ' */
    {0x0398, 0x03d1}, /* 'Θ' -> 'ϑ' */
    {0x0399, 0x0345}, /* 'Ι' -> 'ͅ' */
    {0x0399, 0x1fbe}, /* 'Ι' -> 'ι' */
    {0x039a, 0x03f0}, /* 'Κ' -> 'ϰ' */
    {0x039c, 0x00b5}, /* 'Μ' -> 'µ' */
    {0x03a0, 0x03d6}, /* 'Π' -> 'ϖ' */
    {0x03a1, 0x03f1}, /* 'Ρ' -> 'ϱ' */
    {0x03a3, 0x03c2}, /* 'Σ' -> 'ς' */
    {0x03a6, 0x03d5}, /* 'Φ' -> 'ϕ' */
    {0x03cf, 0x03d7}, /* 'Ϗ' -> 'ϗ' */
    {0x03f4, 0x03b8}, /* 'ϴ' -> 'θ' */
    {0x03f7, 0x03f8}, /* 'Ϸ' -> 'ϸ' */
    {0x03f9, 0x03f2}, /* 'Ϲ' -> 'ϲ' */
    {0x03fa, 0x03fb}, /* 'Ϻ' -> 'ϻ' */
    {0x0412, 0x1c80}, /* 'В' -> 'ᲀ' */
    {0x0414, 0x1c81}, /* 'Д' -> 'ᲁ' */
    {0x041e, 0x1c82}, /* 'О' -> 'ᲂ' */
    {0x0421, 0x1c83}, /* 'С' -> 'ᲃ' */
    {0x0422, 0x1c84}, /* 'Т' -> 'ᲄ' */
    {0x0422, 0x1c85}, /* 'Т' -> 'ᲅ' */
    {0x042a, 0x1c86}, /* 'Ъ' -> 'ᲆ' */
    {0x0462, 0x1c87}, /* 'Ѣ' -> 'ᲇ' */
    {0x04c0, 0x04cf}, /* 'Ӏ' -> 'ӏ' */
    {0x10c7, 0x2d27}, /* 'Ⴧ' -> 'ⴧ' */
    {0x10cd, 0x2d2d}, /* 'Ⴭ' -> 'ⴭ' */
    {0x1c89, 0x1c8a}, /* 'Ᲊ' -> 'ᲊ' */
    {0x1e60, 0x1e9b}, /* 'Ṡ' -> 'ẛ' */
    {0x1e9e, 0x00df}, /* 'ẞ' -> 'ß' */
    {0x1f59, 0x1f51}, /* 'Ὑ' -> 'ὑ' */
    {0x1f5b, 0x1f53}, /* 'Ὓ' -> 'ὓ' */
    {0x1f5d, 0x1f55}, /* 'Ὕ' -> 'ὕ' */
    {0x1f5f, 0x1f57}, /* 'Ὗ' -> 'ὗ' */
    {0x1fbc, 0x1fb3}, /* 'ᾼ' -> 'ᾳ' */
    {0x1fcc, 0x1fc3}, /* 'ῌ' -> 'ῃ' */
    {0x1fec, 0x1fe5}, /* 'Ῥ' -> 'ῥ' */
    {0x1ffc, 0x1ff3}, /* 'ῼ' -> 'ῳ' */
    {0x2126, 0x03c9}, /* 'Ω' -> 'ω' */
    {0x212a, 0x006b}, /* 'K' -> 'k' */
    {0x212b, 0x00e5}, /* 'Å' -> 'å' */
    {0x2132, 0x214e}, /* 'Ⅎ' -> 'ⅎ' */
    {0x2183, 0x2184}, /* 'Ↄ' -> 'ↄ' */
    {0x2c60, 0x2c61}, /* 'Ⱡ' -> 'ⱡ' */
    {0x2c62, 0x026b}, /* 'Ɫ' -> 'ɫ' */
    {0x2c63, 0x1d7d}, /* 'Ᵽ' -> 'ᵽ' */
    {0x2c64, 0x027d}, /* 'Ɽ' -> 'ɽ' */
    {0x2c6d, 0x0251}, /* 'Ɑ' -> 'ɑ' */
    {0x2c6e, 0x0271}, /* 'Ɱ' -> 'ɱ' */
    {0x2c6f, 0x0250}, /* 'Ɐ' -> 'ɐ' */
    {0x2c70, 0x0252}, /* 'Ɒ' -> 'ɒ' */
    {0x2c72, 0x2c73}, /* 'Ⱳ' -> 'ⱳ' */
    {0x2c75, 0x2c76}, /* 'Ⱶ' -> 'ⱶ' */
    {0x2cf2, 0x2cf3}, /* 'Ⳳ' -> 'ⳳ' */
    {0xa64a, 0x1c88}, /* 'Ꙋ' -> 'ᲈ' */
    {0xa77d, 0x1d79}, /* 'Ᵹ' -> 'ᵹ' */
    {0xa78b, 0xa78c}, /* 'Ꞌ' -> 'ꞌ' */
    {0xa78d, 0x0265}, /* 'Ɥ' -> 'ɥ' */
    {0xa7aa, 0x0266}, /* 'Ɦ' -> 'ɦ' */
    {0xa7ab, 0x025c}, /* 'Ɜ' -> 'ɜ' */
    {0xa7ac, 0x0261}, /* 'Ɡ' -> 'ɡ' */
    {0xa7ad, 0x026c}, /* 'Ɬ' -> 'ɬ' */
    {0xa7ae, 0x026a}, /* 'Ɪ' -> 'ɪ' */
    {0xa7b0, 0x029e}, /* 'Ʞ' -> 'ʞ' */
    {0xa7b1, 0x0287}, /* 'Ʇ' -> 'ʇ' */
    {0xa7b2, 0x029d}, /* 'Ʝ' -> 'ʝ' */
    {0xa7b3, 0xab53}, /* 'Ꭓ' -> 'ꭓ' */
    {0xa7c4, 0xa794}, /* 'Ꞔ' -> 'ꞔ' */
    {0xa7c5, 0x0282}, /* 'Ʂ' -> 'ʂ' */
    {0xa7c6, 0x1d8e}, /* 'Ᶎ' -> 'ᶎ' */
    {0xa7cb, 0x0264}, /* 'Ɤ' -> 'ɤ' */
    {0xa7cc, 0xa7cd}, /* 'Ꟍ' -> 'ꟍ' */
    {0xa7d0, 0xa7d1}, /* 'Ꟑ' -> 'ꟑ' */
    {0xa7dc, 0x019b}, /* 'Ƛ' -> 'ƛ' */
};

uint32_t _towcase(uint32_t wc, int lower) {
    int i;
    int lmul;  /* 1 for lower, -1 for upper */
    int lmask; /* 0 for lower, -1/0xffff for upper */

    if (wc <= 0x40                           /* 64 */
        || wc > 0x1e943                      /* >125251 */
        || wc - 0x16e80 <= 0x1e8ff - 0x16e80 /* 31360 */
        || wc - 0x2d2e <= 0xa63f - 0x2d2e    /* 30994 */
        || wc - 0x118e0 <= 0x16e3f - 0x118e0 /* 21856 */
        || wc - 0xabc0 <= 0xff20 - 0xabc0    /* 21345 */
        || wc - 0x10d86 <= 0x1189f - 0x10d86 /* 2842 */
        || wc - 0x587 <= 0x109f - 0x587      /* 2841 */
    )
        return wc;

#ifdef HAVE_LOCALE_TR
    /* check for the 2 turkish mappings if we have a turkish locale. */
    if ((lower && (wc == 0x49 || wc == 0x130)) ||
        (!lower && (wc == 0x69 || wc == 0x131))) {
        const char *loc = setlocale(LC_CTYPE, NULL);
        if (loc && (!strncmp(loc, "tr", 2) || !strncmp(loc, "az", 2))) {
            if (lower) {
                if (wc == 0x49)
                    return 0x131;
                else
                    return 0x69;
            } else {
                if (wc == 0x69)
                    return 0x130;
                else
                    return 0x49;
            }
        }
    }
#endif

    lmul = 2 * lower - 1; /* 1 for lower, -1 for upper */
    lmask = lower - 1;    /* 0 for lower, -1/0xffff for upper */
    /* linear search both */
    for (i = 0; i < 69; i++) {

        int base = casemaps[i].upper + (lmask & casemaps[i].lower);
        assert(i > 0 ? casemaps[i].upper >= casemaps[i - 1].upper : 1);
        if (wc - base < casemaps[i].len) {
            if (casemaps[i].lower == 1) {
                /* Need this exception (wrong lace for titlecase digraphs).
                   Tested from Unicode 4 to 18. We search pairs later. */
                if (!lower && (wc == 0x1F3 || wc == 0x1CC || wc == 0x1C6))
                    return wc - 2;
                if (lower && (wc == 0x1F1 || wc == 0x1CA || wc == 0x1C4))
                    return wc + 2;
                return wc + lower - ((wc - casemaps[i].upper) & 1);
            } else {
                return wc + lmul * casemaps[i].lower;
            }
        }
        if (lower && casemaps[i].upper > wc)
            break;
    }
    for (i = 0; i < 20; i++) {
        unsigned long base = casemapsl[i].upper + (lmask & casemapsl[i].lower);
        assert(i > 0 ? casemapsl[i].upper >= casemapsl[i - 1].upper : 1);
        if (wc - base < casemapsl[i].len) {
            if (casemapsl[i].lower == 1) {
                return wc + lower - ((wc - casemapsl[i].upper) & 1);
            }
            return wc + lmul * casemapsl[i].lower;
        }
        if (lower && casemapsl[i].upper > wc)
            break;
    }
    for (i = 0; i < 128; i++) {
        assert(i > 0 ? pairs[i][0] >= pairs[i - 1][0] : 1);
        if (pairs[i][1 - lower] == wc)
            return pairs[i][lower];
        if (lower && pairs[i][0] > wc)
            break;
    }
    return wc;
}

#undef CASEMAP
#undef CASELACE
